/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.libjf.config.impl.ui.tiny;

import io.gitlab.jfronny.libjf.config.api.v2.ConfigCategory;
import io.gitlab.jfronny.libjf.config.api.v2.ConfigInstance;
import io.gitlab.jfronny.libjf.config.api.v2.Naming;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigScreen;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.TinyConfigTabWrapper;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.EntryInfoWidgetBuilder;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.EntryListWidget;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.Reflowable;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.WidgetFactory;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.entry.WidgetState;
import io.gitlab.jfronny.libjf.config.impl.ui.tiny.presets.PresetsScreen;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_4185;
import net.minecraft.class_8030;
import net.minecraft.class_8087;

@Environment(value=EnvType.CLIENT)
public class TinyConfigTab
implements class_8087 {
    private final ConfigCategory config;
    private final Naming naming;
    private final EntryListWidget list;

    public TinyConfigTab(TinyConfigScreen screen, int headerHeight, ConfigCategory config, Naming naming, class_327 textRenderer, boolean isRoot) {
        Naming nmg;
        class_2561 description;
        this.config = config;
        this.naming = naming;
        LinkedList<String> erroredEntries = new LinkedList<String>();
        List<WidgetState<?>> widgets = EntryInfoWidgetBuilder.buildWidgets(config, naming, screen.widgets, erroredEntries);
        config.fix();
        for (WidgetState<?> widgetState : widgets) {
            widgetState.updateCache();
        }
        this.list = new EntryListWidget(screen.getClient(), textRenderer, screen.field_22789, screen.field_22790 - 36 - headerHeight, headerHeight, isRoot);
        if (!isRoot && (description = naming.description()) != null) {
            this.list.addText(description);
        }
        for (String string : erroredEntries) {
            this.list.addText((class_2561)class_2561.method_43469((String)"libjf-config-core-v2.errored_entry", (Object[])new Object[]{string}));
        }
        if (!isRoot && !config.getPresets().keySet().stream().allMatch(s -> s.equals("libjf-config-core-v2.default"))) {
            this.list.addReference((class_2561)class_2561.method_43471((String)"libjf-config-core-v2.presets"), () -> new PresetsScreen(screen, config, naming, screen::afterSelectPreset));
        }
        for (Map.Entry entry : config.getCategories().entrySet()) {
            nmg = naming.category((String)entry.getKey());
            this.list.addReference(nmg.name(), () -> new TinyConfigScreen((ConfigCategory)entry.getValue(), nmg, screen, false));
        }
        for (WidgetState widgetState : widgets) {
            WidgetFactory.Widget control = widgetState.factory == null ? null : widgetState.factory.build(screen, textRenderer);
            class_4185 resetButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"libjf-config-core-v2.reset"), button -> info.reset()).method_46434(screen.field_22789 - 155, 0, 40, 20).method_46431();
            BooleanSupplier resetVisible = () -> {
                boolean visible;
                resetButton.field_22763 = visible = !Objects.equals(info.entry.getDefault(), info.cachedValue);
                return visible;
            };
            Reflowable reflow = (width, height) -> {
                resetButton.method_46421(width - 155);
                if (control != null) {
                    control.reflow(width, height);
                }
            };
            if (control == null) {
                this.list.addUnknown((class_339)resetButton, resetVisible, widgetState.naming.name(), reflow);
                continue;
            }
            this.list.addButton(control.control(), (class_339)resetButton, resetVisible, widgetState.naming.name(), reflow);
        }
        for (ConfigInstance configInstance : config.getReferencedConfigs()) {
            if (configInstance == null) continue;
            nmg = naming.referenced(configInstance);
            this.list.addReference((class_2561)class_2561.method_43469((String)"libjf-config-core-v2.see-also", (Object[])new Object[]{nmg.name()}), () -> new TinyConfigScreen((ConfigCategory)ci, nmg, screen));
        }
    }

    public class_2561 method_48610() {
        return this.naming.name();
    }

    public class_2561 getDescription() {
        return this.naming.description();
    }

    public class_2561 method_71245() {
        return class_2561.method_43473();
    }

    public void method_48612(Consumer<class_339> consumer) {
        consumer.accept(new TinyConfigTabWrapper(this));
    }

    public void method_48611(class_8030 tabArea) {
        this.list.refreshGrid(tabArea);
    }

    public EntryListWidget getList() {
        return this.list;
    }
}

